# Relaciones entre tablas en Laravel Eloquent

En Laravel (y Orchid), las relaciones entre modelos/tablas se definen mediante migraciones y métodos en los modelos Eloquent.

---

## 1. Relación Uno a Uno  (hasOne / belongsTo)

### Migración ejemplo:
```php
// Tabla profesores (cada profesor pertenece a un usuario)
$table->unsignedBigInteger('user_id');
$table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
```

### Modelo Profesor:
```php
public function user()
{
    return $this->belongsTo(User::class);
}
```

### Modelo User:
```php
public function profesor()
{
    return $this->hasOne(Profesor::class);
}
```

---

## 2. Relación Uno a Muchos (hasMany / belongsTo)

Por ejemplo: un usuario tiene muchos posts

### Migración ejemplo:
```php
// Tabla posts
$table->unsignedBigInteger('user_id');
$table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
```

### Modelo Post:
```php
public function user()
{
    return $this->belongsTo(User::class);
}
```

### Modelo User:
```php
public function posts()
{
    return $this->hasMany(Post::class);
}
```

---

## 3. Relación Muchos a Muchos (belongsToMany)

Por ejemplo: usuarios y roles (tabla pivote role_user)

### Migración ejemplo:
```php
Schema::create('role_user', function (Blueprint $table) {
    $table->unsignedBigInteger('user_id');
    $table->unsignedBigInteger('role_id');
    $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
    $table->foreign('role_id')->references('id')->on('roles')->onDelete('cascade');
    $table->primary(['user_id', 'role_id']);
});
```

### Modelo User:
```php
public function roles()
{
    return $this->belongsToMany(Role::class);
}
```

### Modelo Role:
```php
public function users()
{
    return $this->belongsToMany(User::class);
}
```

---

## ¿Cómo usarlas?

- Uno a uno:  `$profesor->user`,  `$user->profesor`
- Uno a muchos:  `$user->posts`,  `$post->user`
- Muchos a muchos:  `$user->roles`,  `$role->users`

---

_Modifica las migraciones y modelos según tus necesidades_. ¡Laravel hace que trabajar con relaciones sea simple y poderoso!
